import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route, Navigate } from "react-router-dom";
import { AuthProvider } from "@/contexts/AuthContext";
import ProtectedRoute from "@/components/ProtectedRoute";
import AppLayout from "@/components/AppLayout";
import LoginPage from "@/pages/LoginPage";
import RegisterPage from "@/pages/RegisterPage";
import DashboardPage from "@/pages/DashboardPage";
import EmployeesPage from "@/pages/EmployeesPage";
import PayrollPage from "@/pages/PayrollPage";
import PayslipsPage from "@/pages/PayslipsPage";
import TaxSettingsPage from "@/pages/TaxSettingsPage";
import UserManagementPage from "@/pages/UserManagementPage";
import ReportsPage from "@/pages/ReportsPage";
import AuditLogPage from "@/pages/AuditLogPage";
import NotFound from "@/pages/NotFound";

const queryClient = new QueryClient();

const protectedPage = (Page: React.ComponentType) => (
  <ProtectedRoute>
    <AppLayout><Page /></AppLayout>
  </ProtectedRoute>
);

const App = () => (
  <QueryClientProvider client={queryClient}>
    <TooltipProvider>
      <Toaster />
      <Sonner />
      <BrowserRouter>
        <AuthProvider>
          <Routes>
            <Route path="/login" element={<LoginPage />} />
            <Route path="/register" element={<RegisterPage />} />
            <Route path="/" element={<Navigate to="/dashboard" replace />} />
            <Route path="/dashboard" element={protectedPage(DashboardPage)} />
            <Route path="/employees" element={protectedPage(EmployeesPage)} />
            <Route path="/payroll" element={protectedPage(PayrollPage)} />
            <Route path="/payslips" element={protectedPage(PayslipsPage)} />
            <Route path="/reports" element={protectedPage(ReportsPage)} />
            <Route path="/audit-logs" element={protectedPage(AuditLogPage)} />
            <Route path="/tax-settings" element={protectedPage(TaxSettingsPage)} />
            <Route path="/users" element={protectedPage(UserManagementPage)} />
            <Route path="*" element={<NotFound />} />
          </Routes>
        </AuthProvider>
      </BrowserRouter>
    </TooltipProvider>
  </QueryClientProvider>
);

export default App;
