export type Json =
  | string
  | number
  | boolean
  | null
  | { [key: string]: Json | undefined }
  | Json[]

export type Database = {
  // Allows to automatically instantiate createClient with right options
  // instead of createClient<Database, { PostgrestVersion: 'XX' }>(URL, KEY)
  __InternalSupabase: {
    PostgrestVersion: "14.1"
  }
  public: {
    Tables: {
      audit_logs: {
        Row: {
          action: string
          created_at: string
          id: string
          ip_address: string | null
          new_data: Json | null
          old_data: Json | null
          record_id: string | null
          table_name: string
          user_id: string | null
        }
        Insert: {
          action: string
          created_at?: string
          id?: string
          ip_address?: string | null
          new_data?: Json | null
          old_data?: Json | null
          record_id?: string | null
          table_name: string
          user_id?: string | null
        }
        Update: {
          action?: string
          created_at?: string
          id?: string
          ip_address?: string | null
          new_data?: Json | null
          old_data?: Json | null
          record_id?: string | null
          table_name?: string
          user_id?: string | null
        }
        Relationships: []
      }
      employee_sensitive_data: {
        Row: {
          bank_account: string | null
          bank_branch: string | null
          bank_name: string | null
          created_at: string
          employee_id: string
          id: string
          kra_pin: string | null
          mpesa_number: string | null
          nhif_number: string | null
          nssf_number: string | null
          updated_at: string
        }
        Insert: {
          bank_account?: string | null
          bank_branch?: string | null
          bank_name?: string | null
          created_at?: string
          employee_id: string
          id?: string
          kra_pin?: string | null
          mpesa_number?: string | null
          nhif_number?: string | null
          nssf_number?: string | null
          updated_at?: string
        }
        Update: {
          bank_account?: string | null
          bank_branch?: string | null
          bank_name?: string | null
          created_at?: string
          employee_id?: string
          id?: string
          kra_pin?: string | null
          mpesa_number?: string | null
          nhif_number?: string | null
          nssf_number?: string | null
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "employee_sensitive_data_employee_id_fkey"
            columns: ["employee_id"]
            isOneToOne: true
            referencedRelation: "employees"
            referencedColumns: ["id"]
          },
        ]
      }
      employees: {
        Row: {
          basic_salary: number
          branch: string
          created_at: string
          date_joined: string
          department: string
          designation: string
          email: string | null
          employee_number: string
          full_name: string
          id: string
          is_active: boolean
          payment_method: string
          phone: string | null
          updated_at: string
        }
        Insert: {
          basic_salary?: number
          branch?: string
          created_at?: string
          date_joined?: string
          department?: string
          designation?: string
          email?: string | null
          employee_number: string
          full_name: string
          id?: string
          is_active?: boolean
          payment_method?: string
          phone?: string | null
          updated_at?: string
        }
        Update: {
          basic_salary?: number
          branch?: string
          created_at?: string
          date_joined?: string
          department?: string
          designation?: string
          email?: string | null
          employee_number?: string
          full_name?: string
          id?: string
          is_active?: boolean
          payment_method?: string
          phone?: string | null
          updated_at?: string
        }
        Relationships: []
      }
      nhif_rates: {
        Row: {
          created_at: string
          id: string
          is_active: boolean
          max_salary: number | null
          min_salary: number
          monthly_contribution: number
        }
        Insert: {
          created_at?: string
          id?: string
          is_active?: boolean
          max_salary?: number | null
          min_salary?: number
          monthly_contribution: number
        }
        Update: {
          created_at?: string
          id?: string
          is_active?: boolean
          max_salary?: number | null
          min_salary?: number
          monthly_contribution?: number
        }
        Relationships: []
      }
      payroll: {
        Row: {
          basic_salary: number
          bonus: number
          created_at: string
          employee_id: string
          gross_pay: number
          housing_allowance: number
          housing_levy_employee: number
          housing_levy_employer: number
          id: string
          loan_deduction: number
          net_pay: number
          nhif: number
          nssf_employee: number
          nssf_employer: number
          other_allowances: number
          other_deductions: number
          overtime_pay: number
          pay_period: string
          paye: number
          payment_method: string
          processed_at: string
          processed_by: string | null
          sacco_deduction: number
          status: string
          total_deductions: number
          transport_allowance: number
          updated_at: string
        }
        Insert: {
          basic_salary?: number
          bonus?: number
          created_at?: string
          employee_id: string
          gross_pay?: number
          housing_allowance?: number
          housing_levy_employee?: number
          housing_levy_employer?: number
          id?: string
          loan_deduction?: number
          net_pay?: number
          nhif?: number
          nssf_employee?: number
          nssf_employer?: number
          other_allowances?: number
          other_deductions?: number
          overtime_pay?: number
          pay_period: string
          paye?: number
          payment_method?: string
          processed_at?: string
          processed_by?: string | null
          sacco_deduction?: number
          status?: string
          total_deductions?: number
          transport_allowance?: number
          updated_at?: string
        }
        Update: {
          basic_salary?: number
          bonus?: number
          created_at?: string
          employee_id?: string
          gross_pay?: number
          housing_allowance?: number
          housing_levy_employee?: number
          housing_levy_employer?: number
          id?: string
          loan_deduction?: number
          net_pay?: number
          nhif?: number
          nssf_employee?: number
          nssf_employer?: number
          other_allowances?: number
          other_deductions?: number
          overtime_pay?: number
          pay_period?: string
          paye?: number
          payment_method?: string
          processed_at?: string
          processed_by?: string | null
          sacco_deduction?: number
          status?: string
          total_deductions?: number
          transport_allowance?: number
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "payroll_employee_id_fkey"
            columns: ["employee_id"]
            isOneToOne: false
            referencedRelation: "employees"
            referencedColumns: ["id"]
          },
        ]
      }
      profiles: {
        Row: {
          created_at: string
          email: string
          full_name: string
          id: string
          updated_at: string
          user_id: string
        }
        Insert: {
          created_at?: string
          email?: string
          full_name?: string
          id?: string
          updated_at?: string
          user_id: string
        }
        Update: {
          created_at?: string
          email?: string
          full_name?: string
          id?: string
          updated_at?: string
          user_id?: string
        }
        Relationships: []
      }
      tax_rates: {
        Row: {
          bracket_name: string
          created_at: string
          effective_date: string
          id: string
          is_active: boolean
          max_amount: number | null
          min_amount: number
          rate_percentage: number
          updated_at: string
        }
        Insert: {
          bracket_name: string
          created_at?: string
          effective_date?: string
          id?: string
          is_active?: boolean
          max_amount?: number | null
          min_amount?: number
          rate_percentage: number
          updated_at?: string
        }
        Update: {
          bracket_name?: string
          created_at?: string
          effective_date?: string
          id?: string
          is_active?: boolean
          max_amount?: number | null
          min_amount?: number
          rate_percentage?: number
          updated_at?: string
        }
        Relationships: []
      }
      user_roles: {
        Row: {
          created_at: string
          id: string
          role: Database["public"]["Enums"]["app_role"]
          user_id: string
        }
        Insert: {
          created_at?: string
          id?: string
          role: Database["public"]["Enums"]["app_role"]
          user_id: string
        }
        Update: {
          created_at?: string
          id?: string
          role?: Database["public"]["Enums"]["app_role"]
          user_id?: string
        }
        Relationships: []
      }
    }
    Views: {
      [_ in never]: never
    }
    Functions: {
      get_employee_sensitive_info: {
        Args: { p_employee_id: string }
        Returns: {
          bank_account: string
          bank_branch: string
          bank_name: string
          kra_pin: string
          mpesa_number: string
          nhif_number: string
          nssf_number: string
        }[]
      }
      has_role: {
        Args: {
          _role: Database["public"]["Enums"]["app_role"]
          _user_id: string
        }
        Returns: boolean
      }
      is_accountant: { Args: never; Returns: boolean }
      is_admin: { Args: never; Returns: boolean }
      is_hr: { Args: never; Returns: boolean }
    }
    Enums: {
      app_role: "admin" | "hr_officer" | "accountant"
    }
    CompositeTypes: {
      [_ in never]: never
    }
  }
}

type DatabaseWithoutInternals = Omit<Database, "__InternalSupabase">

type DefaultSchema = DatabaseWithoutInternals[Extract<keyof Database, "public">]

export type Tables<
  DefaultSchemaTableNameOrOptions extends
    | keyof (DefaultSchema["Tables"] & DefaultSchema["Views"])
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
        DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Views"])
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
      DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Views"])[TableName] extends {
      Row: infer R
    }
    ? R
    : never
  : DefaultSchemaTableNameOrOptions extends keyof (DefaultSchema["Tables"] &
        DefaultSchema["Views"])
    ? (DefaultSchema["Tables"] &
        DefaultSchema["Views"])[DefaultSchemaTableNameOrOptions] extends {
        Row: infer R
      }
      ? R
      : never
    : never

export type TablesInsert<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Insert: infer I
    }
    ? I
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Insert: infer I
      }
      ? I
      : never
    : never

export type TablesUpdate<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Update: infer U
    }
    ? U
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Update: infer U
      }
      ? U
      : never
    : never

export type Enums<
  DefaultSchemaEnumNameOrOptions extends
    | keyof DefaultSchema["Enums"]
    | { schema: keyof DatabaseWithoutInternals },
  EnumName extends DefaultSchemaEnumNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"]
    : never = never,
> = DefaultSchemaEnumNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"][EnumName]
  : DefaultSchemaEnumNameOrOptions extends keyof DefaultSchema["Enums"]
    ? DefaultSchema["Enums"][DefaultSchemaEnumNameOrOptions]
    : never

export type CompositeTypes<
  PublicCompositeTypeNameOrOptions extends
    | keyof DefaultSchema["CompositeTypes"]
    | { schema: keyof DatabaseWithoutInternals },
  CompositeTypeName extends PublicCompositeTypeNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"]
    : never = never,
> = PublicCompositeTypeNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"][CompositeTypeName]
  : PublicCompositeTypeNameOrOptions extends keyof DefaultSchema["CompositeTypes"]
    ? DefaultSchema["CompositeTypes"][PublicCompositeTypeNameOrOptions]
    : never

export const Constants = {
  public: {
    Enums: {
      app_role: ["admin", "hr_officer", "accountant"],
    },
  },
} as const
