import { supabase } from "@/integrations/supabase/client";

export async function logAudit(params: {
  action: string;
  tableName: string;
  recordId?: string;
  oldData?: Record<string, unknown> | null;
  newData?: Record<string, unknown> | null;
}) {
  const { data: { user } } = await supabase.auth.getUser();
  await supabase.from("audit_logs").insert({
    action: params.action,
    table_name: params.tableName,
    record_id: params.recordId ?? null,
    old_data: params.oldData as any ?? null,
    new_data: params.newData as any ?? null,
    user_id: user?.id ?? null,
  });
}
