import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";

export default function TaxSettingsPage() {
  const fmt = (n: number) => n.toLocaleString();

  const payeBrackets = [
    { name: "First Band", min: 0, max: 24000, rate: 10 },
    { name: "Second Band", min: 24001, max: 32333, rate: 25 },
    { name: "Third Band", min: 32334, max: 500000, rate: 30 },
    { name: "Fourth Band", min: 500001, max: 800000, rate: 32.5 },
    { name: "Fifth Band", min: 800001, max: null, rate: 35 },
  ];

  const nssfBrackets = [
    { tier: "Tier I", min: 0, max: 7000, rate: "6%", maxContrib: 420 },
    { tier: "Tier II", min: 7001, max: 36000, rate: "6%", maxContrib: 1740 },
  ];

  return (
    <div>
      <div className="mb-6">
        <h1 className="text-2xl font-bold">Tax & Deduction Settings</h1>
        <p className="text-muted-foreground text-sm">Kenyan statutory rates — 2024/2025 fiscal year</p>
      </div>

      <div className="grid gap-6 lg:grid-cols-2">
        {/* PAYE */}
        <Card>
          <CardHeader><CardTitle className="text-lg">PAYE Tax Brackets (Monthly)</CardTitle></CardHeader>
          <CardContent className="p-0">
            <Table>
              <TableHeader>
                <TableRow>
                  <TableHead>Band</TableHead>
                  <TableHead className="text-right">Min (KES)</TableHead>
                  <TableHead className="text-right">Max (KES)</TableHead>
                  <TableHead className="text-right">Rate (%)</TableHead>
                </TableRow>
              </TableHeader>
              <TableBody>
                {payeBrackets.map((b) => (
                  <TableRow key={b.name}>
                    <TableCell>{b.name}</TableCell>
                    <TableCell className="text-right font-mono">{fmt(b.min)}</TableCell>
                    <TableCell className="text-right font-mono">{b.max == null ? "∞" : fmt(b.max)}</TableCell>
                    <TableCell className="text-right font-mono">{b.rate}%</TableCell>
                  </TableRow>
                ))}
              </TableBody>
            </Table>
            <p className="text-xs text-muted-foreground px-4 pb-3 pt-2">Personal Relief: KES 2,400/month deducted from gross tax.</p>
          </CardContent>
        </Card>

        {/* SHA */}
        <Card>
          <CardHeader><CardTitle className="text-lg">SHA — Social Health Authority</CardTitle></CardHeader>
          <CardContent className="space-y-3 text-sm">
            <div className="bg-muted rounded-md p-3">
              <p className="font-semibold text-base">2.75% of Gross Pay</p>
              <p className="text-muted-foreground">No upper cap. Replaced NHIF effective October 2024.</p>
            </div>
            <div className="space-y-1 text-muted-foreground">
              <p>• Applies to all gross earnings (basic + allowances + bonuses)</p>
              <p>• Both employee and employer contribute 2.75% each</p>
              <p>• Administered by the Social Health Authority (SHA)</p>
            </div>
            <div className="border rounded-md p-3">
              <p className="font-medium">Example calculation:</p>
              <p className="font-mono mt-1">Gross KES 50,000 × 2.75% = KES 1,375</p>
            </div>
          </CardContent>
        </Card>

        {/* NSSF */}
        <Card>
          <CardHeader><CardTitle className="text-lg">NSSF Contributions (Monthly)</CardTitle></CardHeader>
          <CardContent className="p-0">
            <Table>
              <TableHeader>
                <TableRow>
                  <TableHead>Tier</TableHead>
                  <TableHead className="text-right">Pensionable Min</TableHead>
                  <TableHead className="text-right">Pensionable Max</TableHead>
                  <TableHead className="text-right">Rate</TableHead>
                  <TableHead className="text-right">Max Contrib.</TableHead>
                </TableRow>
              </TableHeader>
              <TableBody>
                {nssfBrackets.map((b) => (
                  <TableRow key={b.tier}>
                    <TableCell className="font-medium">{b.tier}</TableCell>
                    <TableCell className="text-right font-mono">{fmt(b.min)}</TableCell>
                    <TableCell className="text-right font-mono">{fmt(b.max)}</TableCell>
                    <TableCell className="text-right font-mono">{b.rate}</TableCell>
                    <TableCell className="text-right font-mono">{fmt(b.maxContrib)}</TableCell>
                  </TableRow>
                ))}
              </TableBody>
            </Table>
            <p className="text-xs text-muted-foreground px-4 pb-3 pt-2">Both employee and employer contribute equally. Max combined deduction: KES 2,160/month.</p>
          </CardContent>
        </Card>

        {/* Housing Levy */}
        <Card>
          <CardHeader><CardTitle className="text-lg">Affordable Housing Levy</CardTitle></CardHeader>
          <CardContent className="space-y-3 text-sm">
            <div className="bg-muted rounded-md p-3">
              <p className="font-semibold text-base">1.5% of Gross Pay</p>
              <p className="text-muted-foreground">Introduced via Affordable Housing Act 2023.</p>
            </div>
            <div className="space-y-1 text-muted-foreground">
              <p>• Employee contributes 1.5% of gross pay</p>
              <p>• Employer matches with equal 1.5% contribution</p>
              <p>• No upper cap; deducted before PAYE calculation</p>
            </div>
            <div className="border rounded-md p-3">
              <p className="font-medium">Example calculation:</p>
              <p className="font-mono mt-1">Gross KES 50,000 × 1.5% = KES 750</p>
            </div>
          </CardContent>
        </Card>

        {/* M-Pesa */}
        <Card className="lg:col-span-2">
          <CardHeader><CardTitle className="text-lg">Payment Methods</CardTitle></CardHeader>
          <CardContent>
            <div className="grid sm:grid-cols-3 gap-4 text-sm">
              <div className="border rounded-md p-4">
                <p className="font-semibold text-base mb-1">🏦 Bank Transfer</p>
                <p className="text-muted-foreground">Salary credited directly to employee's bank account. Requires bank name, account number, and branch code.</p>
              </div>
              <div className="border rounded-md p-4">
                <p className="font-semibold text-base mb-1">📱 M-Pesa</p>
                <p className="text-muted-foreground">Salary sent via Safaricom M-Pesa to employee's registered phone number. Requires a valid Safaricom number.</p>
              </div>
              <div className="border rounded-md p-4">
                <p className="font-semibold text-base mb-1">💵 Cash</p>
                <p className="text-muted-foreground">Salary paid in cash. Employee must sign a receipt. Suitable for casual or daily workers.</p>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}
